<?php
/*--------------------------------------------------------------
   UpdateSet.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option;

use ArrayIterator;
use IteratorAggregate;
use Webmozart\Assert\Assert;

class UpdateSet implements IteratorAggregate
{
    /**
     * @var array
     */
    private $values;
    
    
    /**
     * Constructor.
     */
    private function __construct(array $values)
    {
        Assert::isMap($values);
        
        $this->values = $values;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(array $updateSet): self
    {
        return new self($updateSet);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): ArrayIterator
    {
        return new ArrayIterator($this->values);
    }
    
    
    /**
     * Return as array.
     */
    public function toArray(): array
    {
        return $this->values;
    }
}